/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import jade.imtp.leap.JICP.JICPConnection;
import jade.imtp.leap.JICP.JICPSPeer;
import jade.mtp.TransportAddress;
import jade.util.Logger;
import java.io.IOException;
import java.net.BindException;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class JICPSConnection
extends JICPConnection {
    private static SSLSocketFactory scsf = null;
    protected static Logger myLogger = Logger.getMyLogger((class$jade$imtp$leap$JICP$JICPSConnection == null ? (class$jade$imtp$leap$JICP$JICPSConnection = JICPSConnection.class$("jade.imtp.leap.JICP.JICPSConnection")) : class$jade$imtp$leap$JICP$JICPSConnection).getName());
    static /* synthetic */ Class class$jade$imtp$leap$JICP$JICPSConnection;

    protected JICPSConnection() {
    }

    public JICPSConnection(TransportAddress ta) throws IOException {
        this.constructJICPSConnectionNoAuth(ta);
    }

    public JICPSConnection(TransportAddress ta, boolean useSSLAuth) throws IOException {
        if (useSSLAuth) {
            this.constructJICPSConnectionWithAuth(ta);
        } else {
            this.constructJICPSConnectionNoAuth(ta);
        }
    }

    private void constructJICPSConnectionNoAuth(TransportAddress ta) throws IOException {
        if (myLogger.isLoggable(Logger.WARNING)) {
            myLogger.log(Logger.WARNING, "Creating JICPSConnection with NO-AUTHENTICATION (only confidentiality).");
        }
        if (scsf == null) {
            try {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(null, null, null);
                scsf = ctx.getSocketFactory();
            }
            catch (Exception e) {
                throw new IOException("Error creating SSLSocketFactory. " + e.toString());
            }
        }
        while (true) {
            try {
                this.sc = scsf.createSocket(ta.getHost(), Integer.parseInt(ta.getPort()));
                ((SSLSocket)this.sc).setEnabledCipherSuites(new String[]{"SSL_DH_anon_WITH_RC4_128_MD5"});
                this.is = this.sc.getInputStream();
                this.os = this.getOutputStream();
            }
            catch (BindException be) {
                continue;
            }
            break;
        }
    }

    private void constructJICPSConnectionWithAuth(TransportAddress ta) throws IOException {
        if (myLogger.isLoggable(Logger.FINE)) {
            myLogger.log(Logger.FINE, "Creating JICPSConnection with MUTUAL AUTHENTICATION.");
        }
        if (scsf == null) {
            try {
                SSLContext ctx = JICPSPeer.createContextWithAuth();
                scsf = ctx.getSocketFactory();
            }
            catch (Exception e) {
                throw new IOException("Error creating SSLSocketFactory. " + e.toString());
            }
        }
        while (true) {
            try {
                this.sc = scsf.createSocket(ta.getHost(), Integer.parseInt(ta.getPort()));
                this.is = this.sc.getInputStream();
                this.os = this.getOutputStream();
            }
            catch (BindException be) {
                continue;
            }
            break;
        }
    }

    public JICPSConnection(Socket s) {
        super(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

